#include "IIC_L.h"
#include "delay.h"
#include "stm32f10x_gpio.h"
#include "USART2.h"
/****************************************************************************
 * Function Name  : LOCAL_IIC
 ****************************************************************************/
/* 
  //寄存器基地址
#define    DWT_CR    *(uint32_t*)0xE0001000
#define    DWT_CYCCNT    *(uint32_t*)0xE0001004
#define    DEM_CR    *(uint32_t*)0xE000EDFC

void delay_us_DWT(uint32_t us)
{

	DWT_CYCCNT = (uint32_t)0u;
	while (((uint32_t)DWT_CYCCNT) < (uint32_t)(72*us-66))
        ;

}
*/

static uint16_t SCL_GPIO_Pin = GPIO_Pin_6;
static uint16_t SDA_GPIO_Pin = GPIO_Pin_7;

static GPIO_TypeDef *SCL_GPIOx = GPIOB;
static GPIO_TypeDef *SDA_GPIOx = GPIOB;

static void I2C_SCL(unsigned char Status)
{
  if (Status)
    GPIO_SetBits(SCL_GPIOx, SCL_GPIO_Pin);
  else
    GPIO_ResetBits(SCL_GPIOx, SCL_GPIO_Pin);
}
static void I2C_SDA(unsigned char Status) // PC6 SDA GPIOx_BSRR
{
  if (Status)
    GPIO_SetBits(SDA_GPIOx, SDA_GPIO_Pin);
  else
    GPIO_ResetBits(SDA_GPIOx, SDA_GPIO_Pin);
}

static void I2C_SDA_OUT(void) // PC6 SDA GPIOx_MODER-> General purpose output mode
{

  GPIO_InitTypeDef GPIO_InitStructure;
  GPIO_InitStructure.GPIO_Pin = SDA_GPIO_Pin;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_10MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD;
  GPIO_Init(SDA_GPIOx, &GPIO_InitStructure);
}

static void I2C_SDA_IN(void) // PC6 SDA GPIOx_MODER->Input mode
{

  GPIO_InitTypeDef GPIO_InitStructure;
  GPIO_InitStructure.GPIO_Pin = SDA_GPIO_Pin;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  GPIO_Init(SDA_GPIOx, &GPIO_InitStructure);
}
// IIC1  产生起始信号 SCL高时 SDA从高变低
static void I2C_StarT(void)
{
  I2C_SDA_OUT();
  I2C_SDA(1);
  delay_us(1);
  I2C_SCL(1);
  delay_us(1);
  I2C_SDA(0);
  delay_us(1);
  I2C_SCL(0);
  delay_us(1);
}

// IIC1 产生停止信号 SCL高时 SDA从低变高
static void I2C_StoP(void)
{
  I2C_SDA_OUT();
  I2C_SDA(0);
  delay_us(1);
  I2C_SCL(1);
  delay_us(1);
  I2C_SDA(1);
}

// IIC1 主机产生应答信号ACK 第9个时钟SCL高时期间SDA为低
static void I2C_Ack(void)
{

  // I2C_SCL(0);
  // delay_us(1);//时钟低时间 读数据里有

  I2C_SDA_OUT();
  I2C_SDA(0);
  delay_us(4); // 时钟低时间
  I2C_SCL(1);
  delay_us(5); // 时钟高时间
  I2C_SCL(0);
  delay_us(1);

  I2C_SDA(1);
  I2C_SDA_IN();
}

// IIC1 主机不产生应答信号NACK 第9个时钟SCL高时期间SDA为高
static void I2C_NAck(void)
{

  // I2C_SCL(0);
  // delay_us(1);//时钟低时间 读数据里有
  I2C_SDA(1);
  delay_us(4); // 时钟低时间

  I2C_SCL(1);
  delay_us(5); // 时钟高时间

  I2C_SCL(0);
  delay_us(1);

  I2C_SDA(1);
  I2C_SDA_IN();
}
// 0:SUCCESS 1:ERROR
static unsigned char I2C_Wait_Ack(void) // 第9个时钟SCL高时期间读取SDA
{
  unsigned char tempTime = 0;
  // I2C_SCL(0);
  // delay_us(1);//时钟低时间 发送数据里有
  I2C_SDA(1);
  I2C_SDA_IN();

  delay_us(4); // 时钟低时间
  I2C_SCL(1);
  delay_us(1); // 时钟高时间

  while (GPIO_ReadInputDataBit(SDA_GPIOx, SDA_GPIO_Pin))
  {
    tempTime++;
    delay_us(1);

    if (tempTime > 250)
    {
      I2C_StoP();

      return 1;
    }
  }
  delay_us(4); // 时钟高时间
  I2C_SCL(0);
  delay_us(1); // 时钟低时间

  return 0;
}

static void I2C_Send_Byte(unsigned char txd)
{
  unsigned char i = 0;
  // I2C_SCL(0);
  // delay_us(1);//时钟低时间 开始信号或者等待应答里有
  I2C_SDA_OUT();

  for (i = 0; i < 8; i++)
  {
    if ((txd & 0x80) > 0) // 0x80  1000 0000
      I2C_SDA(1);
    else
      I2C_SDA(0);

    txd <<= 1;
    delay_us(4); // 时钟低时间
    I2C_SCL(1);
    delay_us(5); // 时钟高时间
    I2C_SCL(0);
    delay_us(1); // 时钟低时间
  }
}

static unsigned char I2C_Read_Byte(unsigned char ack)
{
  unsigned char i = 0, receive = 0;
  unsigned char tempTime = 0;
  // SDA置高放手 在等待应答里或者上一次读信号的NACK或ACK有
  // I2C_SCL(0);
  // delay_us(1);//时钟低时间 在等待应答里或者上一次读信号的NACK或ACK有

  for (i = 0; i < 8; i++)
  {
    delay_us(4); // 时钟低时间
    I2C_SCL(1);
    delay_us(1);                                                               // 时钟高时间
    while ((!GPIO_ReadInputDataBit(SCL_GPIOx, SCL_GPIO_Pin)) && tempTime < 10) // 避免死机
    {
      tempTime += 1;
      delay_us(1);
    }
    receive <<= 1;

    if (GPIO_ReadInputDataBit(SDA_GPIOx, SDA_GPIO_Pin))
      receive++;
    delay_us(4); // 时钟高时间
    I2C_SCL(0);
    delay_us(1); // 时钟低时间
  }

  if (ack == 0)
    I2C_NAck();
  else
    I2C_Ack();

  return receive;
}

void IIC_L_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
  GPIO_InitStructure.GPIO_Pin = SCL_GPIO_Pin;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_10MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD;
  GPIO_Init(SCL_GPIOx, &GPIO_InitStructure);

  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
  GPIO_InitStructure.GPIO_Pin = SDA_GPIO_Pin;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_10MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD;
  GPIO_Init(SDA_GPIOx, &GPIO_InitStructure);
  I2C_SCL(1);
  I2C_SDA(1);
}
void General_Call_IIC_L(unsigned char MSB)
{
  I2C_StarT();
  delay_us(10);
  I2C_Send_Byte(0x00);
  I2C_Wait_Ack();
  delay_us(5);

  I2C_Send_Byte(0x06);
  I2C_Wait_Ack();
  delay_us(5);
  I2C_StoP();
}
void CHECK_ALERT_STATUS_L(unsigned char *MSB)
{
  I2C_StarT();
  I2C_Send_Byte(0x19);
  I2C_Wait_Ack();

  *MSB = I2C_Read_Byte(0);
  I2C_StoP();
}
void W_BYTE_IIC_L(unsigned char slave_addr, unsigned char register_addr, unsigned char MSB)
{
  I2C_StarT();
  I2C_Send_Byte(slave_addr + 0);
  I2C_Wait_Ack();

  I2C_Send_Byte(register_addr);
  I2C_Wait_Ack();

  I2C_Send_Byte(MSB);
  I2C_Wait_Ack();

  I2C_StoP();
}

void R_BYTE_IIC_L(unsigned char slave_addr, unsigned char register_addr, unsigned char *MSB)
{
  I2C_StarT();
  I2C_Send_Byte(slave_addr + 0);
  I2C_Wait_Ack();
  I2C_Send_Byte(register_addr);
  I2C_Wait_Ack();

  I2C_StoP();

  I2C_StarT();

  I2C_Send_Byte(slave_addr + 1);
  I2C_Wait_Ack();

  *MSB = I2C_Read_Byte(0);
  I2C_StoP();
}
void W_2BYTE_IIC_L(unsigned char slave_addr, unsigned char register_addr, unsigned char MSB, unsigned char LSB)
{
  I2C_StarT();
  I2C_Send_Byte(slave_addr + 0);
  I2C_Wait_Ack();

  I2C_Send_Byte(register_addr);
  I2C_Wait_Ack();

  I2C_Send_Byte(MSB);
  I2C_Wait_Ack();

  I2C_Send_Byte(LSB);
  I2C_Wait_Ack();
  delay_us(50);
  I2C_StoP();
}

void R_2BYTE_IIC_L(unsigned char slave_addr, unsigned char register_addr, unsigned char *MSB, unsigned char *LSB)
{

  I2C_StarT();
  I2C_Send_Byte(slave_addr + 0);
  I2C_Wait_Ack();
  I2C_Send_Byte(register_addr);
  I2C_Wait_Ack();
  I2C_StoP();

  I2C_StarT();
  I2C_Send_Byte(slave_addr + 1);
  I2C_Wait_Ack();

  *MSB = I2C_Read_Byte(1);
  *LSB = I2C_Read_Byte(0);

  I2C_StoP();
}
