#include <stdio.h>
#include "IIC_L.h"
#include "delay.h"
#include "GXTR7718.H"
#include "USART2.h"
#define GXTR7718_ADDR 0X98

unsigned char GXTR7718_Shutdown(void) // ضģʽ
{
    unsigned char CODE_ERR = 0x00;
    unsigned char MSB = 0X00;
    W_BYTE_IIC_L(GXTR7718_ADDR, 0x09, 0x40); // SDλ1
    delay_ms(10);
    R_BYTE_IIC_L(GXTR7718_ADDR, 0x03, &MSB);
    if ((MSB & 0x40) != 0x40)
        CODE_ERR = 0x02; // SD ERR
    return CODE_ERR;
}

void GXTR7718_Temp_Local(void) // ¶
{
    unsigned char MSB = 0X00, LSB = 0X00;
    unsigned short REG_VALUE = 0X0000;
    float Temp = 0.0;
    R_BYTE_IIC_L(GXTR7718_ADDR, 0x00, &MSB); // ¶ȸֽ
    R_BYTE_IIC_L(GXTR7718_ADDR, 0x29, &LSB); // ¶ȵֽ
    REG_VALUE = MSB << 8 | LSB;
    if (MSB & 0X80) // ¶
    {
        REG_VALUE = ~REG_VALUE;
        REG_VALUE += 0X0001;
        Temp = REG_VALUE * 0.00390625;
        printf("GXTR7718_TEMP_Local:-%03.6f\r\n", Temp);
    }
    else
    {
        Temp = REG_VALUE * 0.00390625; // չҪ-64
        printf("GXTR7718_TEMP_Local:%03.6f\r\n", Temp);
    }
}

void GXTR7718_Temp_Remote1(void) // Զһ¶
{
    unsigned char MSB = 0X00, LSB = 0X00;
    unsigned short REG_VALUE = 0X0000;
    float Temp = 0.0;
    R_BYTE_IIC_L(GXTR7718_ADDR, 0x01, &MSB); // Զһ¶ȸֽ
    R_BYTE_IIC_L(GXTR7718_ADDR, 0x10, &LSB); // Զһ¶ȵֽ
    REG_VALUE = MSB << 8 | LSB;
     if (MSB & 0X80) // ¶
    {
        REG_VALUE = ~REG_VALUE;
        REG_VALUE += 0X0001;
        Temp = REG_VALUE * 0.00390625;
        printf("GXTR7718_TEMP_Remote1:-%03.6f\r\n", Temp);
    }
    else
    {
        Temp = REG_VALUE * 0.00390625; // չҪ-64
        printf("GXTR7718_TEMP_Remote1:%03.6f\r\n", Temp);
    }
}
