#include <stdio.h>
#include "IIC_L.h"
#include "delay.h"
#include "GXTR3032.H"
#include "USART2.h"
#define GXTR3032_ADDR 0XF8

unsigned char GXTR3032_INIT(void) // ʼչģʽ
{
    unsigned char CODE_ERR = 0x00;
    unsigned char MSB = 0X00;
    W_BYTE_IIC_L(GXTR3032_ADDR, 0x09, 0x04); // RANGEλ1
    delay_ms(10);
    R_BYTE_IIC_L(GXTR3032_ADDR, 0x03, &MSB);
    if ((MSB & 0x04) != 0x04)
        CODE_ERR = 0x01; // INIT ERR
    return CODE_ERR;
}

unsigned char GXTR3032_Shutdown(void) // ضģʽ
{
    unsigned char CODE_ERR = 0x00;
    unsigned char MSB = 0X00;
    W_BYTE_IIC_L(GXTR3032_ADDR, 0x09, 0x40); // SDλ1
    delay_ms(10);
    R_BYTE_IIC_L(GXTR3032_ADDR, 0x03, &MSB);
    if ((MSB & 0x40) != 0x40)
        CODE_ERR = 0x02; // SD ERR
    return CODE_ERR;
}

void GXTR3032_Temp_Local(void) // ¶
{
    unsigned char MSB = 0X00, LSB = 0X00;
    unsigned short REG_VALUE = 0X0000;
    float Temp = 0.0;
    R_BYTE_IIC_L(GXTR3032_ADDR, 0x00, &MSB); // ¶ȸֽ
    R_BYTE_IIC_L(GXTR3032_ADDR, 0x29, &LSB); // ¶ȵֽ
    REG_VALUE = MSB << 8 | LSB;

    Temp = REG_VALUE * 0.00390625 - 64; // չҪ-64
    printf("GXTR3032_TEMP_Local:%03.6f\r\n", Temp);
}

void GXTR3032_Temp_Remote1(void) // Զһ¶
{
    unsigned char MSB = 0X00, LSB = 0X00;
    unsigned short REG_VALUE = 0X0000;
    float Temp = 0.0;
    R_BYTE_IIC_L(GXTR3032_ADDR, 0x01, &MSB); // Զһ¶ȸֽ
    R_BYTE_IIC_L(GXTR3032_ADDR, 0x10, &LSB); // Զһ¶ȵֽ
    REG_VALUE = MSB << 8 | LSB;

    Temp = REG_VALUE * 0.00390625 - 64; // չҪ-64
    printf("GXTR3032_TEMP_Remote1:%03.6f\r\n", Temp);
}

void GXTR3032_Temp_Remote2(void) // Զ̶¶
{
    unsigned char MSB = 0X00, LSB = 0X00;
    unsigned short REG_VALUE = 0X0000;
    float Temp = 0.0;
    R_BYTE_IIC_L(GXTR3032_ADDR, 0x23, &MSB); // Զ̶¶ȸֽ
    R_BYTE_IIC_L(GXTR3032_ADDR, 0x24, &LSB); // Զ̶¶ȵֽ
    REG_VALUE = MSB << 8 | LSB;

    Temp = REG_VALUE * 0.00390625 - 64; // չҪ-64
    printf("GXTR3032_TEMP_Remote2:%03.6f\r\n", Temp);
}

void GXTR3032_Temp_Remote3(void) // Զ¶
{
    unsigned char MSB = 0X00, LSB = 0X00;
    unsigned short REG_VALUE = 0X0000;
    float Temp = 0.0;
    R_BYTE_IIC_L(GXTR3032_ADDR, 0x2A, &MSB); // Զ¶ȸֽ
    R_BYTE_IIC_L(GXTR3032_ADDR, 0x2B, &LSB); // Զ¶ȵֽ
    REG_VALUE = MSB << 8 | LSB;

    Temp = REG_VALUE * 0.00390625 - 64; // չҪ-64
    printf("GXTR3032_TEMP_Remote3:%03.6f\r\n", Temp);
}