#include "GXHT11.h"
#include "delay.h"

//ʼGXHT11IO DQ ͬʱGXHT11Ĵ
//1:
//0:
u8 GXHT11_Init(void)
{
    GPIO_InitTypeDef  GPIO_InitStructure;

    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);	 	//ʹPA˿ʱ

    GPIO_InitStructure.GPIO_Pin = GXHT11_IO;				 				//PA6˿
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD; 		 		//©
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_Init(GPIO_GXHT11, &GPIO_InitStructure);						//ʼIO
    GPIO_SetBits(GPIO_GXHT11, GXHT11_IO);						 				//PA6 

    GXHT11_Rst();  																					//λGXHT11
    return GXHT11_Check();																	//ȴGXHT11ĻӦ
}

/*******************************************************************************
*            : GXHT11_IO_OUT
* 		   	: IO	   
*              : 
*              : 
*******************************************************************************/
void GXHT11_IO_OUT(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;	
	
	GPIO_InitStructure.GPIO_Pin=GXHT11_IO;
	GPIO_InitStructure.GPIO_Speed=GPIO_Speed_10MHz;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
	GPIO_Init(GPIO_GXHT11,&GPIO_InitStructure);
}

/*******************************************************************************
*            : GXHT11_IO_IN
* 		   : SDA	   
*              : 
*              : 
*******************************************************************************/
void GXHT11_IO_IN(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;	
	
	GPIO_InitStructure.GPIO_Pin=GXHT11_IO;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_IPU;
	GPIO_Init(GPIO_GXHT11,&GPIO_InitStructure);
}

//λGXHT11
void GXHT11_Rst(void)
{
    GXHT11_IO_OUT(); 		//SET OUTPUT
    GXHT11_DQ_OUT = 0; 	//DQ
    delay_ms(20);    		//10ms
    GXHT11_DQ_OUT = 1; 	//DQ=1
    delay_us(20);     	//10~30us
}

//ȴGXHT11ĻӦ
//1:δ⵽GXHT11Ĵ
//0:
u8 GXHT11_Check(void)
{
    u8 retry = 0;
    GXHT11_IO_IN();											//SET INPUT
    while(GXHT11_DQ_IN && retry < 100) //GXHT1140~80us
    {
        retry++;
        delay_us(1);
    };
    if(retry >= 100)return 1;
    else retry = 0;
    while(!GXHT11_DQ_IN && retry < 100) //GXHT11ͺٴ40~80us
    {
        retry++;
        delay_us(1);
    };
    if(retry >= 100)return 1;
    return 0;
}

//GXHT11ȡһλ
//ֵ1/0
u8 GXHT11_Read_Bit(void)
{
    u8 retry = 0;
    while(GXHT11_DQ_IN && retry < 100) //ȴΪ͵ƽ
    {
        retry++;
        delay_us(1);
    }
    retry = 0;
    while(!GXHT11_DQ_IN && retry < 100) //ȴߵƽ
    {
        retry++;
        delay_us(1);
    }
    delay_us(40);												//ȴ40us
    if(GXHT11_DQ_IN)return 1;
    else return 0;
}
//GXHT11ȡһֽ
//ֵ
u8 GXHT11_Read_Byte(void)
{
    u8 i, dat;
    dat = 0;
    for(i = 0; i < 8; i++)
    {
        dat <<= 1;
        dat |= GXHT11_Read_Bit();
    }
    return dat;
}

//GXHT11ȡһ
//temp:¶ֵ(Χ:-40~125)
//humi:ʪֵ(Χ:0%~100%)
//ֵ0,;1,ȡʧ
u8 GXHT11_Read_Data(float *temp, u8* humi_th,u8* humi_tl)
{
    u8 buf[5];
    u8 i;
    GXHT11_Rst();
    if(GXHT11_Check() == 0)
    {
        for(i = 0; i < 5; i++) //ȡ40λ
        {
            buf[i] = GXHT11_Read_Byte();
        }
        if((buf[0] + buf[1] + buf[2] + buf[3]) == buf[4])
        {
					
						if(((buf[3]&0x80) >> 7))
						{
							*temp = - (float)((float)buf[2] + ((float)(buf[3] & 0x7F) / 10));
						}
						else
							*temp =  (float)((float)buf[2] + ((float)(buf[3] & 0x7F) / 10));
							
            *humi_th = buf[0];
						*humi_tl = buf[1];					
        }
    }
    else 	return 1;
    return 0;
}

//GXHT11ȡһӦ
//float temp,humi_th,humi_tl;
//GXHT11_Read_Data(&temp, &humi_th, &humi_tl);
//printf("GXHT11_TEMP: %0.1f	HUMI: %d.%d",temp,humi_th,humi_tl);





