#include "GX21M15.h"
#include "delay.h"
#include "al_debug.h"

#define write 0
#define read  1

/****************************************************************************
* Function Name  : IIC_Config
* Description    : ʼGPIO.
* Input          : None
* Output         : None
* Return         : None
****************************************************************************/
void I2C_INIT()
{
    GPIO_InitTypeDef GPIO_InitStructure;

    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA,ENABLE);
    GPIO_InitStructure.GPIO_Pin=I2C_SDA;
    GPIO_InitStructure.GPIO_Speed=GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
    GPIO_Init(GPIOA,&GPIO_InitStructure);

    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA,ENABLE);
    GPIO_InitStructure.GPIO_Pin=I2C_SCL;
    GPIO_InitStructure.GPIO_Speed=GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
    GPIO_Init(GPIOA,&GPIO_InitStructure);

    I2C_SCL_H;
    I2C_SDA_H;
}

/*******************************************************************************
*            : I2C_SDA_OUT
* 		   : SDA
*              : 
*              : 
*******************************************************************************/
void I2C_SDA_OUT()
{
    GPIO_InitTypeDef GPIO_InitStructure;

    GPIO_InitStructure.GPIO_Pin=I2C_SDA;
    GPIO_InitStructure.GPIO_Speed=GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
    GPIO_Init(GPIOA,&GPIO_InitStructure);
}

void I2C_SDA_in(void)
{
    GPIO_InitTypeDef GPIO_InitStructure;

    GPIO_InitStructure.GPIO_Pin=I2C_SDA;
    GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_OD;
    GPIO_Init(GPIOA,&GPIO_InitStructure);
}

//IIC1  ʼź
void I2C_StarT(void)
{
    I2C_SDA_OUT();

    I2C_SDA_H;
    I2C_SCL_H;
    delay_us(5);
    I2C_SDA_L;
    delay_us(6);
    I2C_SCL_L;
}


//IIC1 ֹͣź
void I2C_StoP(void)
{
    I2C_SDA_OUT();

    I2C_SCL_L;
    I2C_SDA_L;
    I2C_SCL_H;
    delay_us(6);
    I2C_SDA_H;
    delay_us(6);
}

//IIC1 ӦźACK
void I2C_Ack(void)
{
    I2C_SCL_L;
    I2C_SDA_OUT();
    I2C_SDA_L;
    delay_us(2);
    I2C_SCL_H;
    delay_us(5);
    I2C_SCL_L;
}

//IIC1 ӦźNACK
void I2C_NAck(void)
{
    I2C_SCL_L;
    I2C_SDA_OUT();
    I2C_SDA_H;
    delay_us(2);
    I2C_SCL_H;
    delay_us(5);
    I2C_SCL_L;
}



//IIC1 ȴӻӦź
//ֵ1 Ӧʧ
//		  0 Ӧɹ
u8 I2C_Wait_Ack(void)
{
    u8 tempTime=0;

    I2C_SDA_in();

    I2C_SDA_H;
    delay_us(1);
    I2C_SCL_H;
    delay_us(1);

    while(GPIO_ReadInputDataBit(GPIO_I2C,I2C_SDA))
    {
        tempTime++;
        delay_us(1);
        if(tempTime>250)
        {
            I2C_StoP();
            return 1;
        }
    }

    I2C_SCL_L;
    delay_us(1);
    return 0;
}


//I2C1 һֽ
void I2C_Send_Byte(u8 txd)
{
    u8 i=0;
    I2C_SDA_OUT();
    I2C_SCL_L;//ʱӿʼݴ
    for(i=0; i<8; i++)
    {
        if((txd&0x80)>0) //0x80  1000 0000
            I2C_SDA_H;
        else
            I2C_SDA_L;
        txd<<=1;
        delay_us(1);
        I2C_SCL_H;
        delay_us(2); //
        I2C_SCL_L;
        delay_us(2);
    }
}


//I2C1 ȡһֽ
u8 I2C_Read_Byte(u8 ack)
{
    u8 i=0,receive=0;
    I2C_SDA_in();
    for(i=0; i<8; i++)
    {
        I2C_SCL_L;
        delay_us(2);
        I2C_SCL_H;
        receive<<=1;
        if(GPIO_ReadInputDataBit(GPIO_I2C,I2C_SDA))
            receive++;
        delay_us(1);
    }
    if(ack==0)
        I2C_NAck();
    else
        I2C_Ack();
    return receive;
}


void GX21M15_read_result(u8 addr)
{
		float temp_value=0.0;
		unsigned char temp[2]={0};
		unsigned int temp_high,temp_low;
		unsigned int low = 0;
		unsigned int tempforh = 0;
		unsigned int judge_posneg = 0;

    I2C_StarT();
    I2C_Send_Byte(addr <<1 | write);//д7λI2C豸ַ0Ϊдȡλ,1Ϊȡλ
    I2C_Wait_Ack();
    I2C_Send_Byte(0x00);
    I2C_Wait_Ack();
	
		delay_ms(100);

    I2C_StarT();
    I2C_Send_Byte(addr <<1 | read);//д7λI2C豸ַ0Ϊдȡλ,1Ϊȡλ
    if(I2C_Wait_Ack()==0)
    {
        temp[0]=I2C_Read_Byte(1);
        temp[1]=I2C_Read_Byte(0);

        I2C_StoP();

    }
    else
    {
        temp[0]=0;
        temp[1]=0;
        I2C_StoP();
    }
	
			
		temp_high = temp[0];
		temp_low = temp[1];
		low = temp_low>>5;
		tempforh = temp_high * 8 + low;
	 
		judge_posneg = (temp_high & 0x80) >> 7;
		if(judge_posneg==0)
		{
			temp_value = tempforh * 0.125;
		}
		else
		{
			tempforh = ( tempforh ^ 0x7FF) + 1;
			temp_value = tempforh * (-0.125);
		}
			

		al_debug_log("addr_0x%x,GX21M15:%2.2f",addr,temp_value);

		temp_high=0;
		temp_low=0;

}


#if 0
int main(void)
{	
	Hardware_Init();
	
	while(1)
	{
		GX21M15_read_result(0x48);//A0 A1 A2ӵ
	}
}
#endif






