/*--------------------------------------------------------------------------------------
  Copyright (c) 2021 GXCAS, Inc. All rights reserved

  File Name   : onewire.h
  Author      : GXCAS
  Date        : 2021-06-24
  Version     : 0.1
  Description : configure the STM32 as a 1-wire master

  Modification History :
  Date      By       Version    Change Description
  ====================================================================================
  21/06/24  GXCAS  0.1        Original
--------------------------------------------------------------------------------------*/

#ifndef __ONEWIRE_HEADER_FILE
#define __ONEWIRE_HEADER_FILE

// library reference
#include "stdio.h"
#include "stdint.h"
#include "stm32f10x_gpio.h"
#include "stm32f10x_rcc.h"

// pin definition
#define ONEWIRE_CLK  RCC_APB2Periph_GPIOB
#define ONEWIRE_PORT GPIOB
#define ONEWIRE_PIN  GPIO_Pin_1

// 1-wire speed definition
#define SPD_STD   0
#define SPD_OD    1

// ACK/NACK
#define ACK   0x01
#define NACK  0x00

// function declaration
void    onewire_init      (void);
void    onewire_pulldown  (void);
void    onewire_release   (void);
uint8_t onewire_receive   (void);
uint8_t onewire_reset     (uint8_t spd);
uint8_t onewire_read_bit  (uint8_t spd);
uint8_t onewire_read      (uint8_t spd);
void    onewire_write_bit (uint8_t spd, uint8_t txd);
void    onewire_write     (uint8_t spd, uint8_t dat);

#endif
