

#ifndef __GX1833e_ONEWIRE_HEADER_FILE
#define __GX1833e_ONEWIRE_HEADER_FILE

#include"stdint.h"
// ACK/NACK
#define GX1833e_ACK      0x01
#define GX1833e_NACK     0x00

// timing definition in microseconds (us)
// 1. SLOT
#define GX1833e_TIME_SLT   70
#define GX1833e_TIME_REC    5
// 2. RESET & PRESENCE
#define GX1833e_TIME_RST  300
#define GX1833e_TIME_MSP   70
// 3. WRITE
#define GX1833e_TIME_W0L   70
#define GX1833e_TIME_W1L    5
// 4. READ
#define GX1833e_TIME_RL     5
#define GX1833e_TIME_MSR   15

// function declaration
uint8_t gx1833e_onewire_reset      (void);
uint8_t gx1833e_onewire_read_bit   (void);
void    gx1833e_onewire_write_bit  (uint8_t txd);
uint8_t gx1833e_onewire_read_byte  (void);
void    gx1833e_onewire_write_byte (uint8_t dat);

#endif
