/*--------------------------------------------------------------------------------------
  Copyright (c) 2023 GXCAS, Inc. All rights reserved

  File Name   : gx1832_driver.h
  File Type   : header file
  Author      : zhengkl
  Date        : 2023-04-11
  Version     : 0.1
  Description : driver for GX1832

  Modification History :
  Date      By       Version    Change Description
  ====================================================================================
  23/04/11  zhengkl  0.1        Original
--------------------------------------------------------------------------------------*/

#ifndef __GX1832_DRIVER_HEADER_FILE
#define __GX1832_DRIVER_HEADER_FILE

// CRC-8 generator polynomial
#define CRC_POLY                 0x8C

// definition of addressing command
#define GX1832_SEARCH            0xF0
#define GX1832_ALARM             0xEC
#define GX1832_READ              0x33
#define GX1832_MATCH             0x55
#define GX1832_SKIP              0xCC

// definition of function command
#define GX1832_CONVERT           0x44
#define GX1832_READ_SCRATCHPAD   0xBE
#define GX1832_WRITE_SCRATCHPAD  0x4E

// function declaration
uint8_t  gx1832_search           (uint64_t * ids);
uint8_t  gx1832_alarm            (uint64_t * ids);
uint64_t gx1832_read             (void);
uint8_t  gx1832_match            (uint64_t   id);
uint8_t  gx1832_skip             (void);
void     gx1832_convert          (void);
int16_t  gx1832_read_temperature (void);
uint64_t gx1832_read_scratchpad  (void);
void     gx1832_write_scratchpad (uint64_t txd);
uint8_t  gx1832_generate_crc8    (uint64_t dat);

#endif
