#include "Gx100S.h"
#include "delay.h"

#define write 0
#define read  1
float F_value = 0;
float Humiture[4];

u8 Humiture_buff1[20];

/****************************************************************************
* Function Name  : IIC_Config
* Description    : ʼGPIO.
* Input          : None
* Output         : None
* Return         : None
****************************************************************************/
void I2C_INIT()
{
    GPIO_InitTypeDef GPIO_InitStructure;
    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);

    GPIO_InitStructure.GPIO_Pin = I2C_SDA;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD;
    GPIO_Init(GPIOA, &GPIO_InitStructure);


    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);
    GPIO_InitStructure.GPIO_Pin = I2C_SCL;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD;
    GPIO_Init(GPIOA, &GPIO_InitStructure);

    I2C_SCL_H;
    I2C_SDA_H;
}

/*******************************************************************************
*            : I2C_SDA_OUT
* 		   : SDA
*              : 
*              : 
*******************************************************************************/
void I2C_SDA_OUT()
{
    GPIO_InitTypeDef GPIO_InitStructure;

    GPIO_InitStructure.GPIO_Pin = I2C_SDA;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD;
    GPIO_Init(GPIOA, &GPIO_InitStructure);
}


void I2C_SDA_in(void)
{
    GPIO_InitTypeDef GPIO_InitStructure;

    GPIO_InitStructure.GPIO_Pin = I2C_SDA;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_OD;
    GPIO_Init(GPIOA, &GPIO_InitStructure);
}


//IIC1  ʼź
void I2C_StarT(void)
{
    I2C_SDA_OUT();

    I2C_SDA_H;
    I2C_SCL_H;
    delay_us(5);
    I2C_SDA_L;
    delay_us(6);
    I2C_SCL_L;
}


//IIC1 ֹͣź
void I2C_StoP(void)
{
    I2C_SDA_OUT();

    I2C_SCL_L;
    I2C_SDA_L;
    I2C_SCL_H;
    delay_us(6);
    I2C_SDA_H;
    delay_us(6);
}

//IIC1 ӦźACK
void I2C_Ack(void)
{
    I2C_SCL_L;
    I2C_SDA_OUT();
    I2C_SDA_L;
    delay_us(2);
    I2C_SCL_H;
    delay_us(5);
    I2C_SCL_L;
}



//IIC1 ӦźNACK
void I2C_NAck(void)
{
    I2C_SCL_L;
    I2C_SDA_OUT();
    I2C_SDA_H;
    delay_us(2);
    I2C_SCL_H;
    delay_us(5);
    I2C_SCL_L;
}



//IIC1 ȴӻӦź
//ֵ1 Ӧʧ
//		  0 Ӧɹ
u8 I2C_Wait_Ack(void)
{
    u8 tempTime = 0;

    I2C_SDA_in();//I2C_SDA_IN();

    I2C_SDA_H;
    delay_us(1);
    I2C_SCL_H;
    delay_us(1);

    while(GPIO_ReadInputDataBit(GPIO_I2C, I2C_SDA))
    {
        tempTime++;
        delay_us(1);
        if(tempTime > 250)
        {
            I2C_StoP();
            return 1;
        }
    }

    I2C_SCL_L;
    delay_us(1);
    return 0;
}


//I2C1 һֽ
void I2C_Send_Byte(u8 txd)
{
    u8 i = 0;
    I2C_SDA_OUT();
    I2C_SCL_L;//ʱӿʼݴ
    for(i = 0; i < 8; i++)
    {
        if((txd & 0x80) > 0) //0x80  1000 0000
            I2C_SDA_H;
        else
            I2C_SDA_L;
        txd <<= 1;
        delay_us(1);
        I2C_SCL_H;
        delay_us(2); //
        I2C_SCL_L;
        delay_us(2);
    }
}


//I2C1 ȡһֽ
u8 I2C_Read_Byte(u8 ack)
{
    u8 i = 0, receive = 0;
    I2C_SDA_in();
    for(i = 0; i < 8; i++)
    {
        I2C_SCL_L;
        delay_us(2);
        I2C_SCL_H;
        //while(!GPIO_ReadInputDataBit(GPIO_I2C,I2C_SCL));
        receive <<= 1;
        if(GPIO_ReadInputDataBit(GPIO_I2C, I2C_SDA))
            receive++;
        delay_us(1);
    }
    if(ack == 0)
        I2C_NAck();
    else
        I2C_Ack();
    return receive;
}


void Gx100S_read_result1(u8 addr)
{
    short tem, hum;
    u8 buff[6];
    float Temperature = 0;

    I2C_StarT();
    I2C_Send_Byte(addr << 1 | write);//д7λI2C豸ַ0Ϊдȡλ,1Ϊȡλ
    I2C_Wait_Ack();
    I2C_Send_Byte(0x00);
    I2C_Wait_Ack();
    
		delay_us(20);

    I2C_StarT();
    I2C_Send_Byte(addr << 1 | read);//д7λI2C豸ַ0Ϊдȡλ,1Ϊȡλ
    if(I2C_Wait_Ack() == 0)
    {
        buff[0] = I2C_Read_Byte(1);
        buff[1] = I2C_Read_Byte(0);

        I2C_StoP();

    }
    else
    {
        buff[0] = 0;
        buff[1] = 0;
        I2C_StoP();
    }
    if(buff[0] & 0x80)
    {
        tem = (buff[0] << 8) | buff[1] ;
        hum = (((~tem) >> 4) + 1) & 0x0fff;
        Temperature = -(float)(hum * 0.0625);
    }
    else
    {
        tem = (buff[0] << 8) | buff[1] ;
        hum = tem >> 4;
        Temperature = (float)(hum * 0.0625);
    }

    sprintf((char *)Humiture_buff1, "addr_0x%x : %3.2f", addr, Temperature); //111.01*C 100.01%2λС
    printf("%s\n\r\n", Humiture_buff1);

    tem = 0;
    hum = 0;

}


/*/////////////////////////////////////////////////////////////////////////////////////

#if 0
int main(void)
{	
	Hardware_Init();
	
	while(1)
	{
		Gx100S_read_result1(0x48);	//addr0->GND addr1->GND
	}
}
#endif

*//////////////////////////////////////////////////////////////////////////////////////


